<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddVideoProfileFields extends Migration
{
    public function up()
    {
        $this->forge->addColumn('school_info', [
            'video_title' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'video_description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'video_embed' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('school_info', 'video_title');
        $this->forge->dropColumn('school_info', 'video_description');
        $this->forge->dropColumn('school_info', 'video_embed');
    }
}
